package gov.va.med.mhv.sm.admin.web.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * This class is a Singleton to allow non-Spring classes (JSF Beans) to reach
 * into a Spring application (Web Services Tier) without intermixing the
 * annotations of JSF, Spring and in some cases CDI. This intermixing has
 * resulted in unpredictable bean lifecycles and the inability to leverage JSF
 * scopes such as View or extended scopes from other JSF-centric API's such as
 * Seam, Weld, etc.
 *
 * @author DNS
 *
 */
public class SpringContext implements ApplicationContextAware {
	private static ApplicationContext context;

	public void setApplicationContext(ApplicationContext context) throws BeansException {
		SpringContext.context = context;
	}

	public static ApplicationContext getApplicationContext() {
		return context;

	}
}